#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import print_function, unicode_literals
#
#   This file is part of the KDE project
#   Copyright (C) 2010-2015 Jarosław Staniek <staniek@kde.org>
#
#   Shared Data Compiler (SDC)

version = '0.3'

#   A tool that takes a header file with C++ class declaration with specification
#   of class' data members and injects getters, setters and facilities for
#   Qt 5-compatible implicitly/explicitly sharing. Tedious, manual work is considerably
#   reduced. The generated code is enriched with Doxygen-style documentation.
#
#   Syntax:
#    Add an //SDC: comment to the class declaration line
#        class MYLIB_EXPORT MyClass [: public SuperClass] //SDC: [CLASS_OPTIONS]
#
#    supported CLASS_OPTIONS: namespace=NAMESPACE, with_from_to_map,
#                             operator==, explicit, virtual_dtor, custom_clone
#
#    TODO: explain details in README-SDC.md
#
#    Specification of each class' data members should be in form:
#
#        TYPE NAME; //SDC: [DATA_MEMBER_OPTIONS]
#
#    Supported DATA_MEMBER_OPTIONS: default=DEFAULT_VALUE, no_getter, no_setter,
#                                   getter=CUSTOM_GETTER_NAME,
#                                   setter=CUSTOM_SETTER_NAME,
#                                   custom, custom_getter, custom_setter,
#                                   default_setter=DEFAULT_SETTER_PARAM,
#                                   mutable, simple_type, invokable,
#                                   internal, custom_clone
#    If NAME contains '(' then 'TYPE NAME;' is added to the shared data class
#    as a method declaration.
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Library General Public License for more details.
#
#   You should have received a copy of the GNU Library General Public License
#   along with this program; see the file COPYING.  If not, write to
#   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#   Boston, MA 02110-1301, USA.
#
#   As a special exception, you may create a larger work that contains
#   code generated by the Shared Data Compiler and distribute that work
#   under terms of the GNU Lesser General Public License (LGPL) as published
#   by the Free Software Foundation; either version 2.1 of the License,
#   or (at your option) any later version or under terms that are fully
#   compatible with these licenses.
#
#   Alternatively, if you modify or redistribute the Shared Data Compiler tool
#   itself, you may (at your option) remove this special exception, which will
#   cause the resulting generted source code files to be licensed under
#   the GNU General Public License (either version 2 of the License, or
#   at your option under any later version) without this special exception.
#
#   This special exception was added by Jarosław Staniek.
#   Contact him for more licensing options, e.g. using in non-Open Source projects.
#
