#include "EXTERN.h"         // globals/constant import locations
#include "perl.h"           // Perl symbols, structures and constants definition
#include "XSUB.h"           // xsubpp functions and macros
#include <stdio.h>
#include <stdlib.h>

typedef struct Doubly {
    int data;
    struct Doubly* next;
    struct Doubly* prev;
} *Doubly;

// Function to create a new node with given value as data
Doubly createNode(int data)
{
    Doubly newNode = (Doubly*)malloc(sizeof(Doubly)*3);
    newNode->data = data;
    newNode->next = NULL;
    newNode->prev = NULL;
    return newNode;
}

// Function to insert a node at the end
Doubly insertAtEnd(Doubly** head, int data)
{
    // creating new node
    Doubly newNode = createNode(data);

    // check if DLL is empty
    if (*head == NULL) {
        head = newNode;
        return &newNode;
    }

    Doubly temp = *head;
    while (temp->next != NULL) {
        temp = temp->next;
    }
    temp->next = newNode;
    newNode->prev = temp;

    return newNode;
}


MODULE = Doubly  PACKAGE = Doubly
PROTOTYPES: DISABLE

Doubly
new(...)
	CODE:
		RETVAL = createNode(100);
	OUTPUT:
		RETVAL


Doubly
add(self, ...)
	Doubly self
	CODE:
		RETVAL = insertAtEnd(&self, SvIV(ST(1)));
	OUTPUT:
		RETVAL

Doubly
next(self, ...)
	Doubly self
	CODE:
		Doubly next = self->next;
		RETVAL = next;
	OUTPUT:
		RETVAL

int
data(self)
	Doubly self
	CODE:
		RETVAL = self->data;
	OUTPUT:
		RETVAL


